---
title: Create a Capsule
description: Package your workflow for Gumball
---

import { Steps } from '@astrojs/starlight/components';

## What is a Capsule?

Capsule = source code + `capsule.toml` (plus optional Docker build settings).

The only required file is `capsule.toml`. You connect your source code (a Git repository) when you submit.

`Dockerfile` is optional:

- If you provide a custom `Dockerfile`, Gumball uses it.
- If you don’t, Gumball generates a default one automatically.

<Steps>
1. **Write `capsule.toml`**

   Keep it simple. Focus on what users input and what image to run.

   ```toml
   [package]
   name = "my-awesome-app"
   version = "1.0.0"
   description = "Image upscaler"
   category = "image"

   [metadata]
   display_name = "AI Upscaler"
   icon = "✨"
   tags = ["image", "upscale"]

   [inputs]
   image = { type = "file", label = "Upload an image" }
   scale = { type = "number", default = 2, label = "Scale" }

   [run]
   image = "ghcr.io/yourname/upscaler:latest"
   ```

   You can either publish a prebuilt image (like the example above) or let Gumball build your image from source.

2. **(Optional) Add a custom `Dockerfile`**

   Commit a `Dockerfile` to your repo if you need full control over the build.

   If you don’t provide one, Gumball generates a default `Dockerfile` automatically.

3. **(Optional) Push a prebuilt image**

   ```bash
   docker build -t ghcr.io/yourname/my-awesome-app:latest .
   docker push ghcr.io/yourname/my-awesome-app:latest
   ```

4. **Submit for review**

   In the developer portal, submit your Capsule with:

   - `capsule.toml` (**required**, either committed in the repo or uploaded via drag & drop)
   - Your Git repository (source code)
   - (Optional) a custom `Dockerfile` in the repo
   - (Optional) a prebuilt Docker image reference (e.g. `ghcr.io/...`)
</Steps>

## Next steps

- [Publish](/developers/publish/)
- [capsule.toml reference](/developers/reference/capsule-toml/)
