---
title: capsule.toml
description: Public capsule.toml fields (developer-facing)
---

## What developers should write

Gumball’s public documentation focuses on the fields you control.
Scheduling, GPU pooling, and runtime tuning are handled by the platform.

```toml
[package]
name = "my-awesome-app"
version = "1.0.0"
description = "画像を高画質化するアプリ"
category = "image"

[metadata]
display_name = "AI高画質化"
icon = "✨"
tags = ["image", "upscale"]

[inputs]
image = { type = "file", label = "画像をアップロード" }
scale = { type = "number", default = 2, label = "拡大倍率" }

[run]
image = "ghcr.io/yourname/upscaler:latest"
```

## How to add `capsule.toml`

`capsule.toml` is the only required file. You connect your source code (a Git repository) when submitting.

Provide `capsule.toml` in either of these ways:

- **Git repository**: add `capsule.toml` to the repo (commonly at the repository root) and commit it.
- **Drag & drop**: upload `capsule.toml` in the developer portal when submitting for review.

## Dockerfile (optional)

- If your repo includes a custom `Dockerfile`, Gumball uses it.
- If not, Gumball generates a default `Dockerfile` automatically.

## Not documented (platform-managed)

These are internal/optimized by Gumball and should not be required for developers:

- `[requirements]` (e.g. `platform`, `vram_min`, `vram_recommended`)
- `[execution]` (e.g. `runtime`, `startup_timeout`, `signals`)
- `[routing]` (e.g. `weight`, `fallback_to_cloud`, `cloud_capsule`)
- `[model]` (e.g. `source`, `quantization`)
